document.addEventListener("DOMContentLoaded", () => {
    const clockInBtn = document.getElementById("clock-in-btn");
    const clockOutBtn = document.getElementById("clock-out-btn");
    const tableBody = document.getElementById("work-hours-table");

    // Fetch and render the work hours table
    const fetchWorkHours = async () => {
        try {
            const response = await fetch("../php/work-hours.php");
            const result = await response.json();

            if (result.data) {
                renderTable(result.data);
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error("Error fetching work hours:", error);
        }
    };

    const renderTable = (data) => {
        tableBody.innerHTML = "";
        data.forEach((row) => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
                <td>${row.date}</td>
                <td>${row.clock_in_time}</td>
                <td>${row.clock_out_time}</td>
                <td>${row.total_work_hours}</td>
            `;
            tableBody.appendChild(tr);
        });
    };

    const sendClockAction = async (action) => {
        const formData = new FormData();
        formData.append("action", action);

        try {
            const response = await fetch("../php/work-hours.php", {
                method: "POST",
                body: formData,
            });

            const result = await response.json();

            if (result.success) {
                alert(result.success);
                fetchWorkHours(); // Refresh the table
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error("Error sending clock action:", error);
        }
    };

    clockInBtn.addEventListener("click", () => sendClockAction("clock-in"));
    clockOutBtn.addEventListener("click", () => sendClockAction("clock-out"));

    fetchWorkHours();
});
